import os
import json
import numpy as np

def mean_std(arr):
    return np.mean(arr), np.std(arr)

def process_factscore_jsons(directory_path):
    for filename in os.listdir(directory_path):
        if filename.endswith(".json"):
            file_path = os.path.join(directory_path, filename)
            try:
                with open(file_path, 'r') as f:
                    data = json.load(f)

                response_ratios = []
                hallucination_scores = []
                utility_scores = []
                total_facts = []
                supported_facts = []
                unsupported_facts = []
                factscores = []

                for item in data:
                    for prompt, content in item.items():
                        scores = content.get("scores", {})
                        total_facts.append(content.get("total_num_of_facts", 0))
                        supported_facts.append(content.get("num_supported_facts", 0))
                        unsupported_facts.append(content.get("num_unsupported_facts", 0))
                        factscores.append(content.get("factscore", 0.0))

                print(f"\nFile: {filename}")
                for name, arr in [
                    ("Factscore", factscores),
                    ("Total Facts", total_facts),
                    ("Supported Facts", supported_facts),
                    ("Unsupported Facts", unsupported_facts)
                ]:
                    mean, std = mean_std(arr)
                    print(f"  {name:20}: {mean:.4f} ± {std:.4f}")

            except Exception as e:
                print(f"Error processing {filename}: {e}")

if __name__ == "__main__":
    process_factscore_jsons("conditioned_bio_t0.7")